/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import java.util.HashMap;
import java.util.Vector;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Util;
import org.w3c.css.values.CssColorConstants;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssOperator;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.HSL;
import org.w3c.css.values.HSLA;
import org.w3c.css.values.RGB;
import org.w3c.css.values.RGBA;

public class CssColor
extends CssValue
implements CssColorConstants,
CssOperator {
    public static final int type = 3;
    Object color = null;
    RGB rgb = null;
    RGBA rgba = null;
    HSL hsl = null;
    HSLA hsla = null;
    static HashMap<String, Object> definedColors;
    static HashMap<String, String> deprecatedColors;
    static CssIdent inherit;

    public final int getType() {
        return 3;
    }

    public CssColor() {
        this.color = inherit;
    }

    public CssColor(ApplContext ac, String s) throws InvalidParamException {
        this.setIdentColor(s, ac);
    }

    public void set(String s, ApplContext ac) throws InvalidParamException {
        if (s.charAt(0) == '#') {
            this.setShortRGBColor(s.toLowerCase(), ac);
        } else {
            this.setIdentColor(s, ac);
        }
    }

    public Object get() {
        if (this.color != null) {
            if (this.color == inherit) {
                return null;
            }
            return this.color;
        }
        return this.rgb;
    }

    public boolean isDefault() {
        return this.color == inherit;
    }

    public String toString() {
        if (this.color != null) {
            if (this.color == inherit) {
                return inherit.toString();
            }
            return this.color.toString();
        }
        if (this.rgba != null) {
            return this.rgba.toString();
        }
        if (this.hsl != null) {
            return this.hsl.toString();
        }
        if (this.hsla != null) {
            return this.hsla.toString();
        }
        return this.rgb.toString();
    }

    public void setRGBColor(CssExpression exp, ApplContext ac) throws InvalidParamException {
        CssNumber number;
        CssValue val = exp.getValue();
        char op = exp.getOperator();
        this.color = null;
        this.rgb = new RGB();
        if (val == null || op != ',') {
            throw new InvalidParamException("invalid-color", ac);
        }
        switch (val.getType()) {
            case 5: {
                number = (CssNumber)val;
                this.rgb.setRed(this.clippedIntValue(number.getInt(), ac));
                this.rgb.setPercent(false);
                break;
            }
            case 4: {
                this.rgb.setRed(this.clippedPercentValue(((Float)val.get()).floatValue(), ac));
                this.rgb.setPercent(true);
                break;
            }
            default: {
                throw new InvalidParamException("rgb", val, ac);
            }
        }
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null || op != ',') {
            throw new InvalidParamException("invalid-color", ac);
        }
        switch (val.getType()) {
            case 5: {
                if (this.rgb.isPercent()) {
                    throw new InvalidParamException("percent", val, ac);
                }
                number = (CssNumber)val;
                this.rgb.setGreen(this.clippedIntValue(number.getInt(), ac));
                break;
            }
            case 4: {
                if (!this.rgb.isPercent()) {
                    throw new InvalidParamException("integer", val, ac);
                }
                this.rgb.setGreen(this.clippedPercentValue(((Float)val.get()).floatValue(), ac));
                break;
            }
            default: {
                throw new InvalidParamException("rgb", val, ac);
            }
        }
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null) {
            throw new InvalidParamException("invalid-color", ac);
        }
        switch (val.getType()) {
            case 5: {
                if (this.rgb.isPercent()) {
                    throw new InvalidParamException("percent", val, ac);
                }
                number = (CssNumber)val;
                this.rgb.setBlue(this.clippedIntValue(number.getInt(), ac));
                break;
            }
            case 4: {
                if (!this.rgb.isPercent()) {
                    throw new InvalidParamException("integer", val, ac);
                }
                this.rgb.setBlue(this.clippedPercentValue(((Float)val.get()).floatValue(), ac));
                break;
            }
            default: {
                throw new InvalidParamException("rgb", val, ac);
            }
        }
        exp.next();
        if (exp.getValue() != null) {
            throw new InvalidParamException("rgb", exp.getValue(), ac);
        }
    }

    private void setShortRGBColor(String s, ApplContext ac) throws InvalidParamException {
        int r;
        boolean islong;
        int v = s.length();
        boolean bl = islong = v == 7;
        if (v != 4 && !islong) {
            throw new InvalidParamException("rgb", s, ac);
        }
        int idx = 1;
        if ((r = Character.digit(s.charAt(idx++), 16)) < 0) {
            throw new InvalidParamException("rgb", s, ac);
        }
        if (islong) {
            if ((v = Character.digit(s.charAt(idx++), 16)) < 0) {
                throw new InvalidParamException("rgb", s, ac);
            }
            r = (r << 4) + v;
        } else {
            r |= r << 4;
        }
        int g = Character.digit(s.charAt(idx++), 16);
        if (g < 0) {
            throw new InvalidParamException("rgb", s, ac);
        }
        if (islong) {
            if ((v = Character.digit(s.charAt(idx++), 16)) < 0) {
                throw new InvalidParamException("rgb", s, ac);
            }
            g = (g << 4) + v;
        } else {
            g |= g << 4;
        }
        int b = Character.digit(s.charAt(idx), 16);
        if (b < 0) {
            throw new InvalidParamException("rgb", s, ac);
        }
        if (islong) {
            if ((v = Character.digit(s.charAt(++idx), 16)) < 0) {
                throw new InvalidParamException("rgb", s, ac);
            }
            b = (b << 4) + v;
        } else {
            b |= b << 4;
        }
        this.color = null;
        this.rgb = new RGB(r, g, b);
        this.rgb.output = s;
    }

    private void setIdentColor(String s, ApplContext ac) throws InvalidParamException {
        String lower_s = s.toLowerCase();
        Object obj = definedColors.get(lower_s);
        if (obj != null) {
            if (obj instanceof RGB) {
                this.color = lower_s;
                this.rgb = (RGB)obj;
            } else if (obj instanceof RGBA) {
                this.color = lower_s;
                this.rgba = (RGBA)obj;
            } else if (obj instanceof String) {
                this.color = (String)obj;
            }
            return;
        }
        if (deprecatedColors.get(lower_s) != null) {
            this.color = lower_s;
            ac.getFrame().addWarning("deprecated", s);
            return;
        }
        throw new InvalidParamException("value", s, "color", ac);
    }

    public boolean equals(Object cssColor) {
        if (!(cssColor instanceof CssColor)) {
            return false;
        }
        if (this.color != null) {
            return this.color.equals(((CssColor)cssColor).color);
        }
        if (this.rgb != null) {
            return this.rgb.equals(((CssColor)cssColor).rgb);
        }
        if (this.rgba != null) {
            return this.rgba.equals(((CssColor)cssColor).rgba);
        }
        if (this.hsl != null) {
            return this.hsl.equals(((CssColor)cssColor).hsl);
        }
        if (this.hsla != null) {
            return this.hsla.equals(((CssColor)cssColor).hsla);
        }
        return false;
    }

    public void setRGBAColor(Vector exp, ApplContext ac) throws InvalidParamException {
        CssNumber number;
        this.color = null;
        this.rgba = new RGBA();
        CssValue val = (CssValue)exp.elementAt(0);
        if (val instanceof CssNumber) {
            number = (CssNumber)val;
            this.rgba.r = this.clippedIntValue(number.getInt(), ac);
            this.rgba.setPercent(false);
        } else if (val instanceof CssPercentage) {
            this.rgba.r = Float.valueOf(this.clippedPercentValue(((Float)val.get()).floatValue(), ac));
            this.rgba.setPercent(true);
        } else {
            throw new InvalidParamException("rgb", val, ac);
        }
        val = (CssValue)exp.elementAt(1);
        if (val instanceof CssNumber) {
            number = (CssNumber)val;
            if (this.rgba.isPercent()) {
                throw new InvalidParamException("percent", val, ac);
            }
            this.rgba.g = this.clippedIntValue(number.getInt(), ac);
        } else if (val instanceof CssPercentage) {
            if (!this.rgba.isPercent()) {
                throw new InvalidParamException("integer", val, ac);
            }
            this.rgba.g = Float.valueOf(this.clippedPercentValue(((Float)val.get()).floatValue(), ac));
        } else {
            throw new InvalidParamException("rgb", val, ac);
        }
        val = (CssValue)exp.elementAt(2);
        if (val instanceof CssNumber) {
            number = (CssNumber)val;
            if (this.rgba.isPercent()) {
                throw new InvalidParamException("percent", val, ac);
            }
            this.rgba.b = this.clippedIntValue(number.getInt(), ac);
        } else if (val instanceof CssPercentage) {
            if (!this.rgba.isPercent()) {
                throw new InvalidParamException("integer", val, ac);
            }
            this.rgba.b = Float.valueOf(this.clippedPercentValue(((Float)val.get()).floatValue(), ac));
        } else {
            throw new InvalidParamException("rgb", val, ac);
        }
        val = (CssValue)exp.elementAt(3);
        if (!(val instanceof CssNumber)) {
            throw new InvalidParamException("rgb", val, ac);
        }
        this.rgba.a = this.clippedAlphaValue(((Float)val.get()).floatValue(), ac);
    }

    public void setHSLColor(Vector exp, ApplContext ac) throws InvalidParamException {
        this.color = null;
        this.hsl = new HSL();
        CssNumber h = new CssNumber();
        CssPercentage s = new CssPercentage();
        CssPercentage l = new CssPercentage();
        h.set(exp.elementAt(0).toString(), ac);
        if (((Float)h.get()).intValue() > 360 || ((Float)h.get()).intValue() < 0) {
            throw new InvalidParamException("angle", exp.elementAt(0).toString(), ac);
        }
        s.set(exp.elementAt(1).toString(), ac);
        l.set(exp.elementAt(2).toString(), ac);
        this.hsl.h = h;
        this.hsl.s = s;
        this.hsl.l = l;
    }

    public void setHSLAColor(Vector exp, ApplContext ac) throws InvalidParamException {
        Float a;
        this.color = null;
        this.hsla = new HSLA();
        CssNumber h = new CssNumber();
        CssPercentage s = new CssPercentage();
        CssPercentage l = new CssPercentage();
        h.set(exp.elementAt(0).toString(), ac);
        if (((Float)h.get()).intValue() > 360 || ((Float)h.get()).intValue() < 0) {
            throw new InvalidParamException("angle", exp.elementAt(0).toString(), ac);
        }
        s.set(exp.elementAt(1).toString(), ac);
        l.set(exp.elementAt(2).toString(), ac);
        try {
            a = new Float(((CssValue)exp.elementAt(3)).toString());
        }
        catch (Exception e) {
            throw new InvalidParamException("rgb", exp.elementAt(3).toString(), ac);
        }
        if (a.floatValue() < 0.0f || a.floatValue() > 1.0f) {
            ac.getFrame().addWarning("out-of-range", Integer.toString(a.intValue()));
            a = this.clippedAlphaValue(a.floatValue(), ac);
        }
        this.hsla.h = h;
        this.hsla.s = s;
        this.hsla.l = l;
        this.hsla.a = a;
    }

    private int clippedIntValue(int rgb, ApplContext ac) {
        if (rgb < 0 || rgb > 255) {
            ac.getFrame().addWarning("out-of-range", Util.displayFloat(rgb));
            return rgb < 0 ? 0 : 255;
        }
        return rgb;
    }

    private float clippedPercentValue(float p, ApplContext ac) {
        if ((double)p < 0.0 || (double)p > 100.0) {
            ac.getFrame().addWarning("out-of-range", Util.displayFloat(p));
            return (double)p < 0.0 ? 0.0f : 100.0f;
        }
        return p;
    }

    private Float clippedAlphaValue(float p, ApplContext ac) {
        if ((double)p < 0.0 || (double)p > 1.0) {
            ac.getFrame().addWarning("out-of-range", Util.displayFloat(p));
            return new Float((double)p < 0.0 ? 0.0 : 1.0);
        }
        return new Float(p);
    }

    static {
        inherit = new CssIdent("inherit");
        definedColors = new HashMap();
        deprecatedColors = new HashMap();
        definedColors.put("aliceblue", new RGB(240, 248, 255));
        definedColors.put("antiquewhite", new RGB(250, 235, 215));
        definedColors.put("aqua", new RGB(0, 255, 255));
        definedColors.put("aquamarine", new RGB(127, 255, 212));
        definedColors.put("azure", new RGB(240, 255, 255));
        definedColors.put("beige", new RGB(245, 245, 220));
        definedColors.put("bisque", new RGB(255, 228, 196));
        definedColors.put("black", new RGB(0, 0, 0));
        definedColors.put("blanchedalmond", new RGB(255, 235, 205));
        definedColors.put("blue", new RGB(0, 0, 255));
        definedColors.put("blueviolet", new RGB(138, 43, 226));
        definedColors.put("brown", new RGB(165, 42, 42));
        definedColors.put("burlywood", new RGB(222, 184, 135));
        definedColors.put("cadetBlue", new RGB(95, 158, 160));
        definedColors.put("chartreuse", new RGB(127, 255, 0));
        definedColors.put("chocolate", new RGB(210, 105, 30));
        definedColors.put("coral", new RGB(255, 127, 80));
        definedColors.put("cornflowerblue", new RGB(100, 149, 237));
        definedColors.put("cornsilk", new RGB(255, 248, 220));
        definedColors.put("crimson", new RGB(220, 20, 60));
        definedColors.put("cyan", new RGB(0, 255, 255));
        definedColors.put("darkblue", new RGB(0, 0, 139));
        definedColors.put("darkcyan", new RGB(0, 139, 139));
        definedColors.put("darkgoldenrod", new RGB(184, 134, 11));
        definedColors.put("darkgray", new RGB(169, 169, 169));
        definedColors.put("darkgreen", new RGB(0, 100, 0));
        definedColors.put("darkkhaki", new RGB(189, 183, 107));
        definedColors.put("darkmagenta", new RGB(139, 0, 139));
        definedColors.put("darkolivegreen", new RGB(85, 107, 47));
        definedColors.put("darkorange", new RGB(255, 140, 0));
        definedColors.put("darkorchid", new RGB(153, 50, 204));
        definedColors.put("darkred", new RGB(139, 0, 0));
        definedColors.put("darksalmon", new RGB(233, 150, 122));
        definedColors.put("darkseagreen", new RGB(143, 188, 143));
        definedColors.put("darkslateblue", new RGB(72, 61, 139));
        definedColors.put("darkslategray", new RGB(47, 79, 79));
        definedColors.put("darkturquoise", new RGB(0, 206, 209));
        definedColors.put("darkviolet", new RGB(148, 0, 211));
        definedColors.put("deeppink", new RGB(255, 20, 147));
        definedColors.put("deepskyblue", new RGB(0, 191, 255));
        definedColors.put("dimgray", new RGB(105, 105, 105));
        definedColors.put("dodgerblue", new RGB(30, 144, 255));
        definedColors.put("firebrick", new RGB(178, 34, 34));
        definedColors.put("floralwhite", new RGB(255, 250, 240));
        definedColors.put("forestgreen", new RGB(34, 139, 34));
        definedColors.put("fuchsia", new RGB(255, 0, 255));
        definedColors.put("gainsboro", new RGB(220, 220, 220));
        definedColors.put("ghostwhite", new RGB(248, 248, 255));
        definedColors.put("gold", new RGB(255, 215, 0));
        definedColors.put("goldenrod", new RGB(218, 165, 32));
        definedColors.put("gray", new RGB(128, 128, 128));
        definedColors.put("green", new RGB(0, 128, 0));
        definedColors.put("greenyellow", new RGB(173, 255, 47));
        definedColors.put("honeydew", new RGB(240, 255, 240));
        definedColors.put("hotpink", new RGB(255, 105, 180));
        definedColors.put("indianred", new RGB(205, 92, 92));
        definedColors.put("indigo", new RGB(75, 0, 130));
        definedColors.put("ivory", new RGB(255, 255, 240));
        definedColors.put("khaki", new RGB(240, 230, 140));
        definedColors.put("lavender", new RGB(230, 230, 250));
        definedColors.put("lavenderblush", new RGB(255, 240, 245));
        definedColors.put("lawngreen", new RGB(124, 252, 0));
        definedColors.put("lemonchiffon", new RGB(255, 250, 205));
        definedColors.put("lightblue", new RGB(173, 216, 230));
        definedColors.put("lightcoral", new RGB(240, 128, 128));
        definedColors.put("lightcyan", new RGB(224, 255, 255));
        definedColors.put("lightgoldenrodyellow", new RGB(250, 250, 210));
        definedColors.put("lightgreen", new RGB(144, 238, 144));
        definedColors.put("lightgrey", new RGB(211, 211, 211));
        definedColors.put("lightpink", new RGB(255, 182, 193));
        definedColors.put("lightsalmon", new RGB(255, 160, 122));
        definedColors.put("lightseagreen", new RGB(32, 178, 170));
        definedColors.put("lightskyblue", new RGB(135, 206, 250));
        definedColors.put("lightslategray", new RGB(119, 136, 153));
        definedColors.put("lightsteelblue", new RGB(176, 196, 222));
        definedColors.put("lightyellow", new RGB(255, 255, 224));
        definedColors.put("lime", new RGB(0, 255, 0));
        definedColors.put("limegreen", new RGB(50, 205, 50));
        definedColors.put("linen", new RGB(250, 240, 230));
        definedColors.put("magenta", new RGB(255, 0, 255));
        definedColors.put("maroon", new RGB(128, 0, 0));
        definedColors.put("mediumaquamarine", new RGB(102, 205, 170));
        definedColors.put("mediumblue", new RGB(0, 0, 205));
        definedColors.put("mediumorchid", new RGB(186, 85, 211));
        definedColors.put("mediumpurple", new RGB(147, 112, 219));
        definedColors.put("mediumseagreen", new RGB(60, 179, 113));
        definedColors.put("mediumslateblue", new RGB(123, 104, 238));
        definedColors.put("mediumspringgreen", new RGB(0, 250, 154));
        definedColors.put("mediumturquoise", new RGB(72, 209, 204));
        definedColors.put("mediumvioletred", new RGB(199, 21, 133));
        definedColors.put("midnightblue", new RGB(25, 25, 112));
        definedColors.put("mintcream", new RGB(245, 255, 250));
        definedColors.put("mistyrose", new RGB(255, 228, 225));
        definedColors.put("moccasin", new RGB(255, 228, 181));
        definedColors.put("navajowhite", new RGB(255, 222, 173));
        definedColors.put("navy", new RGB(0, 0, 128));
        definedColors.put("oldlace", new RGB(253, 245, 230));
        definedColors.put("olive", new RGB(128, 128, 0));
        definedColors.put("olivedrab", new RGB(107, 142, 35));
        definedColors.put("orange", new RGB(255, 165, 0));
        definedColors.put("orangered", new RGB(255, 69, 0));
        definedColors.put("orchid", new RGB(218, 112, 214));
        definedColors.put("palegoldenrod", new RGB(238, 232, 170));
        definedColors.put("palegreen", new RGB(152, 251, 152));
        definedColors.put("paleturquoise", new RGB(175, 238, 238));
        definedColors.put("palevioletred", new RGB(219, 112, 147));
        definedColors.put("papayawhip", new RGB(255, 239, 213));
        definedColors.put("peachpuff", new RGB(255, 218, 185));
        definedColors.put("peru", new RGB(205, 133, 63));
        definedColors.put("pink", new RGB(255, 192, 203));
        definedColors.put("plum", new RGB(221, 160, 221));
        definedColors.put("powderBlue", new RGB(176, 224, 230));
        definedColors.put("purple", new RGB(128, 0, 128));
        definedColors.put("red", new RGB(255, 0, 0));
        definedColors.put("rosybrown", new RGB(188, 143, 143));
        definedColors.put("royalblue", new RGB(65, 105, 225));
        definedColors.put("saddlebrown", new RGB(139, 69, 19));
        definedColors.put("salmon", new RGB(250, 128, 114));
        definedColors.put("sandybrown", new RGB(244, 164, 96));
        definedColors.put("seagreen", new RGB(46, 139, 87));
        definedColors.put("seashell", new RGB(255, 245, 238));
        definedColors.put("sienna", new RGB(160, 82, 45));
        definedColors.put("silver", new RGB(192, 192, 192));
        definedColors.put("skyblue", new RGB(135, 206, 235));
        definedColors.put("slateblue", new RGB(106, 90, 205));
        definedColors.put("slategray", new RGB(112, 128, 144));
        definedColors.put("snow", new RGB(255, 250, 250));
        definedColors.put("springgreen", new RGB(0, 255, 127));
        definedColors.put("steelblue", new RGB(70, 130, 180));
        definedColors.put("tan", new RGB(210, 180, 140));
        definedColors.put("teal", new RGB(0, 128, 128));
        definedColors.put("thistle", new RGB(216, 191, 216));
        definedColors.put("tomato", new RGB(255, 99, 71));
        definedColors.put("turquoise", new RGB(64, 224, 208));
        definedColors.put("violet", new RGB(238, 130, 238));
        definedColors.put("wheat", new RGB(245, 222, 179));
        definedColors.put("white", new RGB(255, 255, 255));
        definedColors.put("whitesmoke", new RGB(245, 245, 245));
        definedColors.put("yellow", new RGB(255, 255, 0));
        definedColors.put("yellowgreen", new RGB(154, 205, 50));
        definedColors.put("grey", new RGB(128, 128, 128));
        definedColors.put("darkslategrey", new RGB(47, 79, 79));
        definedColors.put("dimgrey", new RGB(105, 105, 105));
        definedColors.put("lightgray", new RGB(211, 211, 211));
        definedColors.put("lightslategrey", new RGB(119, 136, 153));
        definedColors.put("slategrey", new RGB(112, 128, 144));
        definedColors.put("transparent", new RGBA(new Integer(0), new Integer(0), new Integer(0), new Float(0.0f)));
        deprecatedColors.put("activeborder", "ActiveBorder");
        deprecatedColors.put("activecaption", "ActiveCaption");
        deprecatedColors.put("appworkspace", "AppWorkspace");
        deprecatedColors.put("background", "Background");
        deprecatedColors.put("buttonface", "ButtonFace");
        deprecatedColors.put("buttonhighlight", "ButtonHighlight");
        deprecatedColors.put("buttonshadow", "ButtonShadow");
        deprecatedColors.put("buttontext", "ButtonText");
        deprecatedColors.put("captiontext", "CaptionText");
        deprecatedColors.put("graytext", "GrayText");
        deprecatedColors.put("highlight", "Highlight");
        deprecatedColors.put("highlighttext", "HighlightText");
        deprecatedColors.put("inactiveborder", "InactiveBorder");
        deprecatedColors.put("inactivecaption", "InactiveCaption");
        deprecatedColors.put("inactivecaptiontext", "InactiveCaptionText");
        deprecatedColors.put("infobackground", "InfoBackground");
        deprecatedColors.put("infotext", "InfoText");
        deprecatedColors.put("menu", "Menu");
        deprecatedColors.put("menutext", "MenuText");
        deprecatedColors.put("scrollbar", "Scrollbar");
        deprecatedColors.put("threeddarkshadow", "ThreeDDarkShadow");
        deprecatedColors.put("threedface", "ThreeDFace");
        deprecatedColors.put("threedhighlight", "ThreeDHighlight");
        deprecatedColors.put("threedlightshadow", "ThreeDLightShadow");
        deprecatedColors.put("threedshadow", "ThreeDShadow");
        deprecatedColors.put("window", "Window");
        deprecatedColors.put("windowframe", "WindowFrame");
        deprecatedColors.put("windowtext", "WindowText");
        definedColors.put("flavor", "flavor");
        definedColors.put("currentcolor", "currentColor");
    }
}

